//
//  MCSyncDefines.h
//  GWSyncServices
//
//  Created by Michael Clark on 22/02/07.
//  Copyright 2007 Marketcircle Inc. All rights reserved.
//

#import <Foundation/Foundation.h>

#import "MCLog.h"


#define MCSyncDefaultTimeoutSeconds        900
    // The default amount of seconds to wait for a new sync session to begin
#define MCSyncDefaultPullTimeoutSeconds    900
    // The default amount of seconds to wait for a pull only sync session to begin


typedef enum {
	MCSyncModeNo,
	MCSyncModeAny,
	MCSyncModeSlow,
	MCSyncModeFast,
	MCSyncModeRefresh // This one resets the sync client and performs a slow sync
} MCSyncMode;

typedef enum {
	MCSyncChangeTypeAdd = 1,
	MCSyncChangeTypeModify, 
	MCSyncChangeTypeDelete
} MCSyncChangeType;

typedef enum {
	MCSyncChangeOutcomeNotSet = 0,
	MCSyncChangeOutcomeRejected,  // The sync engine will tell Sync Services that we rejected the change ()
	MCSyncChangeOutcomeIgnored,   // The sync engine will no longer process changes with outcome ignored and will not tell Sync Services anything about this change
	MCSyncChangeOutcomeAccepted,
	MCSyncChangeOutcomeNone // When None is used, the receiver is telling the caller to handle it
} MCSyncChangeOutcome;


/* Keys for MCUserDefaults */
extern NSString *MCSyncServicesEnabled; // BOOL


/* Types for Preferences -- these should be moved to GWSyncDefines */
typedef enum {
	GWSyncContactsListTypeUndefined = -1,
	GWSyncContactsListTypeAll = 0,
	GWSyncContactsListTypeMy,
	GWSyncContactsListTypeCustom
} GWSyncContactsListType;

typedef enum {
	GWSyncContactsGroupTypeUndefined = -1,
	GWSyncContactsGroupTypeAll = 0,
	GWSyncContactsGroupTypeDaylite,
	GWSyncContactsGroupTypeCustom
} GWSyncContactsGroupType;

typedef enum {
	GWSyncCalendarsCategoryTypeUndefined = -1,
	GWSyncCalendarsCategoryTypeICal = 0,
	GWSyncCalendarsCategoryTypeDaylite,
	GWSyncCalendarsCategoryTypeSynced,
	GWSyncCalendarsCategoryTypeConflicts
} GWSyncCalendarsCategoryType;


// Notification Names
extern NSString*   MCSyncEngineStartedSyncNotification;
extern NSString*   MCSyncEngineCompletedSyncNotification;


// NSUserDefault Keys - Debugging
extern NSString*   MCSyncDisableTrickleSyncDefaultKey;


// Used to store data in the NSThreads threadDictionary
extern NSString*     MCSyncWorkerThreadSessionKey;
extern NSString*     MCSyncWorkerThreadClientKey;
extern NSString*     MCSyncWorkerThreadObjectLookUpKey;
extern NSString*     MCSyncWorkerThreadAllowedIdentifiersLookUpKey;

/* Keys for Preferences dictionaries (sync group config settings) - these should be moved to GWSyncDefines */

/* Keys for GWSyncContactEntityConfig, and strings representing types */
extern NSString *GWSyncContactsEnabled; // BOOL

extern NSString *GWSyncContactsList; // string - one of the following - settings use GWSyncContactsListType and convert for dictionary
extern NSString *GWSyncContactsListAll;
extern NSString *GWSyncContactsListMy;
extern NSString *GWSyncContactsListCustom;

extern NSString *GWSyncContactsGroup; // string - one of the following - settings use GWSyncContactsGroupType and convert for dictionary
extern NSString *GWSyncContactsGroupAll;
extern NSString *GWSyncContactsGroupDaylite;
extern NSString *GWSyncContactsGroupCustom;

extern NSString *GWSyncContactsSourceListID;
extern NSString *GWSyncOrganizationsSourceListID;

extern NSString *GWSyncContactsEnablePalmCategories;

/* Keys for GWSyncCalendarsEntityConfig */
extern NSString *GWSyncCalendarsEnabled; // BOOL
extern NSString *GWSyncCalendarsCategories; // array - categorySettings objects
extern NSString *GWSyncCalendarsSyncedTimeblockCategories; // dictionary where each key is a categoryID from a synced timeblock category; values ignored
extern NSString *GWSyncCalendarsSyncedTaskCategories; // dictionary where each key is a categoryID from a synced task category; values ignored

extern NSString *GWSyncCalendarsCategory; // string - one of the following - settings use GWSyncCalendarsCategoryType and convert for dictionary
extern NSString *GWSyncCalendarsCategoryICal;
extern NSString *GWSyncCalendarsCategoryDaylite;
extern NSString *GWSyncCalendarsCategorySynced;
extern NSString *GWSyncCalendarsCategoryConflicts;

extern NSString *GWSyncCalendarsCategoryName;
extern NSString *GWSyncCalendarsCategoryID;
extern NSString *GWSyncCalendarsCategoryColor;
extern NSString *GWSyncCalendarsCalendarID;
extern NSString *GWSyncCalendarsCalendarDescription;


@class MCFileLogger;

// File Logging Conveniences
extern void MCSyncLog(SEL selector, id object, MCFileLogger* logger, MCLogLevel level, NSString* format, ...);

#define MCSyncErrorLog(_format_, _args_...) \
MCSyncLog(_cmd, self, __logger, MCLogLevelError, _format_, ## _args_);

#define MCSyncWarnLog(_format_, _args_...) \
	MCSyncLog(_cmd, self, __logger, MCLogLevelWarn, _format_, ## _args_);

#define MCSyncInfoLog(_format_, _args_...) \
MCSyncLog(_cmd, self, __logger, MCLogLevelInfo, _format_, ## _args_);

#define MCSyncVerboseLog(_format_, _args_...) \
MCSyncLog(_cmd, self, __logger, MCLogLevelVerbose, _format_, ## _args_);

#define MCSyncDebugLog(_format_, _args_...) \
MCSyncLog(_cmd, self, __logger, MCLogLevelDebug, _format_, ## _args_);


extern NSString*  MCSyncCreateIdentifier(NSNumber* recordID, NSString* appEntityName, NSString* ssEntityName);
extern NSNumber*  MCSyncExtractRecordIdentifier(NSString* identifier);

extern NSString*  MCSyncStringForChangeOutcome(MCSyncChangeOutcome outcome);

@interface MCSyncDefines : NSObject {

}

//+ (NSString*)createSyncServicesIdentifierForRecordID: (NSNumber*)recordID syncServicesEntityName: (NSString*)entityName;
//+ (NSNumber*)extractRecordIdentifierFromSyncServicesIdentifier: (NSString*)identifier;

+ (int)GWSyncContactsListAsInt:(NSString*)aType;
+ (NSString*)GWSyncContactsListAsString:(int)aType;

+ (int)GWSyncContactsGroupAsInt:(NSString*)aType;

@end
